IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Filter_Last_Act]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Filter_Last_Act]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
--
-- =============================================
-- Author		:	mihaia
-- Created date	:	04/18/2012
-- Description	:	Gets the last act info.
-- =============================================
-- =============================================
-- Update by:	silvicap
-- Update date: 25.10.2012
-- Description:	Separated orders from acts. 
-- =============================================

CREATE PROCEDURE [dbo].[usp_Filter_Last_Act] 
	@PATIENT_UID UNIQUEIDENTIFIER, 
	@VISTA_SITE_UID UNIQUEIDENTIFIER,
	@ACT_TYPE VARCHAR(20) = null
AS
BEGIN
	SET NOCOUNT ON;

		IF @ACT_TYPE IS NULL
			BEGIN			 
				 SELECT * 
				 FROM 
				  (SELECT AR.ID,
							AR.IEN,
							AR.ORDERED_DATE,
							AR.DOMAIN_ID
					 FROM ADMISSION_REQ AR 
					 WHERE  AR.VISTA_SITE_UID = @VISTA_SITE_UID AND AR.PATIENT_UID = @PATIENT_UID
					 UNION ALL
					 SELECT MR.ID,
							MR.IEN,
							MR.ORDERED_DATE,
							MR.DOMAIN_ID
					 FROM MOVEMENT_REQ MR 
					 WHERE  MR.VISTA_SITE_UID = @VISTA_SITE_UID AND MR.PATIENT_UID = @PATIENT_UID
					 UNION ALL
					 SELECT DR.ID,
							DR.IEN,
							DR.ORDERED_DATE,
							DR.DOMAIN_ID
					 FROM DISCHARGE_REQ DR 
					 WHERE DR.VISTA_SITE_UID = @VISTA_SITE_UID AND DR.PATIENT_UID = @PATIENT_UID
					 UNION ALL
					 SELECT DI.ID,
							NULL AS IEN,
							DI.DATE_ENTERED AS ORDERED_DATE,
							DI.DOMAIN_ID
					 FROM DISCHARGE_INT DI
					 WHERE DI.VISTA_SITE_UID = @VISTA_SITE_UID AND DI.PATIENT_UID = @PATIENT_UID) ORDERS
				  ORDER BY ORDERED_DATE DESC
			END
	ELSE
		BEGIN
					
			IF @ACT_TYPE = 'DISCHARGE_INT'
				BEGIN
					 SELECT TOP 1 DI.ID,
							NULL AS IEN,
							DI.DATE_ENTERED AS ORDERED_DATE,
							DI.DOMAIN_ID
					 FROM DISCHARGE_INT DI
					 WHERE DI.VISTA_SITE_UID = @VISTA_SITE_UID AND DI.PATIENT_UID = @PATIENT_UID
					 ORDER BY DI.DATE_ENTERED DESC
				END
			ELSE
				BEGIN
					DECLARE @SQL NVARCHAR(MAX)
					SET @SQL = 'SELECT ID,
									   IEN,
									   ORDERED_DATE,
									   DOMAIN_ID
								FROM ' + @ACT_TYPE + ' 
								WHERE PATIENT_UID = ''' + CONVERT(VARCHAR(36), @PATIENT_UID) + ''' AND VISTA_SITE_UID =  ''' + CONVERT(VARCHAR(36), @VISTA_SITE_UID) + ''' 
								ORDER BY ORDERED_DATE DESC
								'
					EXECUTE sp_executesql @SQL
				END
		END		
END
GO